}  pLASERJET                                                                                                              }   C:\WS\INSET\PIX\WORDSTAR.PIX  








 			!
 COMPLETE WORDSTAR FOR DOS 7.0 ARCHIVE


 	~	~	!
 Using and Customizing WordStar for DOS


 	,,!
 by Robert J. Sawyer

 	,,!
 sawyer@sfwriter.com

 	! 
 

 	!
 Version 1.4

 	jj!
 Wednesday, July 31, 2024


.h1 WordStar 7.0 Archive / #




 	!
 This document is provided in both a plain-text version as

 	!
 -README.TXT and as a WordStar document named -README.WS


 	!
 It is also available online at:

 	

!
 https://sfwriter.com/ws7.htm#readme




 	!
 VIEWING THIS FILE

When viewing this (or any) WordStar document, you can toggle the 
display of print controls and command tags on and off using the 
command ^OD -- hold down Ctrl, hit the letter O, then hit the 
letter D.  As with all two-letter WordStar commands, you can 
continue to hold down the Ctrl key when issuing the second 
letter, but you don't have to.

(If you're viewing -README.TXT instead of -README.WS, there are 
no control codes or command tags to display.)




 	2
2
!
 WORDSTAR IN THE TWENTY-FIRST CENTURY

WordStar for DOS is abandonware.  The company that made it is 
long defunct, and the software hasn't been updated since December 
1992.  The version provided here -- WordStar for DOS 7.0 Rev. D 
-- is the final one ever produced.

Why might you want to use such old software?  See my essay 
"WordStar: A Writer's Word Processor" in the file WORDSTAR.WS, or 
read the online version here:  
   7   3                     

 	@@!
 https://sfwriter.com/wordstar.htm

Also see my summary of WordStar's strengths in the file 
STRENGTH.WS or STRENGTH.TXT.

The file OLDTIMES.WS is a sample WordStar document you can play 
around with.




 	HH!
 DOCUMENTATION

I've provided all the documentation that came with WordStar 7.0 
as full-text-searchable Adobe Acrobat PDF files.  They are in the 
folder C:\WS\MANUALS.

See also all the *.WS or *.TXT files in C:\WS and various 
subfolders.  If a file has both a .WS and .TXT version, the 
former is in WordStar format and the latter is in plain text 
format.

(From WordStar's opening screen, you can select <Alt-F> then H to 
set WordStar to temporarily only show *.WS or *.TXT files in its 
directory display, making them easier to find.)

README.TXT is the actual WordStar README file that came with 
WordStar.  PATCH.LST (which I'm also providing as PATCH.TXT so 
that it can be opened with Windows text editors) contains 
extensive information on customizing WordStar.

If you've used WordStar 6.0 but not WordStar 7.0 this manual in 
C:\WS\MANUALS will be helpful:


 	FF!
 Upgrading from a Previous Release (WordStar 7).pdf

And if you've used WordStar 4.0 or below, but never a later 
version, this manual in "C:\WS\Manuals\WordStar 5" is a very 
useful guide to the many new features; it's much more 
comprehensive that the "Upgrading from a Previous Release 
(WordStar 7).pdf" manual:


 	!
 "WordStar Professional Release 5 -- What's New.pdf"




 	bb!

 RUNNING WORDSTAR ON MODERN OPERATING SYSTEMS

SHORT VERSION: if you're using Windows, create a shortcut on your 
desktop to this program provided as part of this archive:


 	\
\
!
 C:\WS\DOSBox-X\DOSBox-X.exe

Double-click on that shortcut, and WordStar for DOS 7.0 should 
run.  (Note that unless you set "Run as Administrator," under 
"Advanced" in the Shortcut, you will not be able to open or edit    7   3                     files in the root directory of Drive C.)

LONG VERSION: To run WordStar under Windows, Linux, or Mac 
operating systems, use the free and open source MS-DOS emulator 
DOSBox-X (not plain old DOSBox):


 	!
 https://dosbox-x.com

DOSBox-X has a huge configuration file.  It is located here:


 	

!
 C:\WS\DOSBOX-X\dosbox-x.conf

The final lines in that file establish legal drive letters and 
also set what program will run upon booting DOSBox-X.

Since WordStar (by default) and many of its ancillary programs 
expect an 80-column by 25-line screen, in the [ttf] section of 
dosbox-x.conf, I've set these values:

lins=25
cols=80

(Alternatively, you can use the DOSBox-X utility 80X25.COM, 
located in C:\WS, to change your screen to 80 rows by 25 columns 
prior to invoking programs that require that screen size.)

In the [ttf] section of dosbox-x.conf, I've also set this value: 
WP = WS (for "word processor equals WordStar) to enable actual 
boldface and italics under WordStar.

.cp2
I've set DOSBox-X to use the Iosevka Fixed typeface family, but 
you can use any monospaced font that supports the PC-8 character 
set; I've provided these alternatives typeface families in the 
C:\WS\DOSBox-X folder: Liberation Mono, DejaVu Sans, and Free 
Mono; you can also use Consolas, which comes with most versions 
of Windows.

You can specify the fonts of your choice (separate regular, bold, 
italic, and bold-italic versions) in the [ttf] of dosbox-x.conf.

   Iosevka Fixed and Consolas both have a good period, a good 

 	hh
 comma, a good hyphen, a normal lower-case "L," and a slashed 

 	hh
 zero.  They shows multiple underscores (____) as discrete 

 	hh
 characters.

 Liberation Mono has a good period, a good comma, a narrow 

 	hh
 hyphen, a normal lower-case "L," and a dotted zero.  It shows 

 	hh
 multiple underscores as discrete characters.

 DejaVu Sans Mono has a good period, a good comma, a narrow 

 	hh
 hyphen, a weird lower-case "L", and a faintly dotted zero.  It 

 	hh
 shows multiple underscores as one continuous line.

 Free Mono, which is a Courier typeface, has a good period, a 

 	hh
 good comma, a wide hyphen, a normal lower-case "L," and an    7   3                     
 	hh
 undotted/unslashed zero.  It shows multiple underscores as 

 	hh
 discrete characters.  


 	!
   

If for some reason DOSBox-X doesn't meet your needs, alternatives 
are vDosPlus (http://www.vdosplus.org) or the less-robust vDos 
(https://www.vdos.info).  Development on vDosPlus has been 
discontinued, but vDos is still maintained.

This page by me is devoted to using WordStar under vDosPlus:


 	!
 https://sfwriter.com/ws-vdos.htm

I have provided a complete installation of vDosPlus.  To use it, 
create a shortcut on your desktop to this program:


 	\
\
!
 C:\WS\vDosPlus\vDosPlus.exe

Double click on that shortcut, and WordStar for DOS 7.0 should 
run.  (Note that unless you set "Run as Administrator," under 
"Advanced" in the Shortcut, you may not be able to open or edit 
files in the root directory of Drive C.)

If the text isn't razor sharp, edit the properties for the 
shortcut.  On the "Compatibility" tab select "Change high DPI 
settings," then select "Program DPI" and choose "I signed into 
Windows" from the dropdown list.  On that same screen, select 
"High DPI scaling override," and choose "Application" from the 
dropdown list.

Configuration options for vDosPlus are set in these two files:


 	\
\
!
 C:\WS\vDosPlus\autoexec.txt

 	!
 C:\WS\vDosPlus\config.txt



If you've been reading the file -README.TXT and you've now got 
WordStar up and running, switch over to -README.WS to continue; 
it's a WordStar document version of the same file.  Not only does 
it look prettier, you'll be able to try out the things discussed 
below if you're reading from within WordStar.




 	!
 ISSUING WORDSTAR COMMANDS

Classic WordStar commands are issued by holding down the Ctrl key 
while simultaneously pressing another key.  WordStar indicates 
the Ctrl key on its menus and in its manuals with the caret 
symbol: ^V (the command for toggling between insert and overtype 
modes) means hold down both Ctrl and V.  ^KB (the command for 
marking the beginning of a block of text) means hold down Ctrl 
and K simultaneously and then press B; for the second key in a    7   3                     two-key command, you can keep the Ctrl key down or not, whichever 
you prefer.

For the elegant logic behind the classic WordStar interface, see 
my explanation in the file WORDSTAR.WS or the online version at 
my website:


 	@@!
 https://sfwriter.com/wordstar.htm




 	

!
 DIFFERENT VERSIONS OF WORDSTAR

See the file C:\WS\VERSIONS.WS (or C:\WS\VERSIONS.TXT) for 
information on all the many different versions of WordStar 7 I've 
provided in this archive.  The versions principally differ in the 
amount of on-screen help WordStar gives you and in their color 
schemes:

  
 	 h 
 WS.EXE is pretty much a default version of WordStar, including 

 	hh
 the new pulldown menus added in WordStar 7.


 	 h 
 WS2.EXE exclusively uses the classic WordStar interface; if 

 	hh
 you've used any previous version of WordStar, the look-and-feel 

 	hh
 of this version will be very familiar.


 	 h 
 WSRJS.EXE and WS2RJS.EXE are counterparts of the above but with 

 	hh
 less-harsh color schemes.


 	 h 
 SAWYER.EXE is my heavily customized installation, with minimal 

 	hh
 screen clutter and numerous other tweaks.  

There are many other version here, too, all described in 
VERSIONS.TXT.




 	!
 EDITING TWO DOCUMENTS AT ONCE

You can open a second WordStar or text file from within 
WordStar's editing window with the ^OK command.  When prompted, 
select D for "document" (a WordStar file) or N for "nondocument" 
(a text file that you want to keep free of WordStar formatting 
codes).

To make each editing window full screen (instead of each one 
taking up half the screen), issue ^OM and select F.  To change 
that to the default, go to WSCHANGE menu D (WordStar), C (Other 
features), G (Miscellaneous), H (Size of other window), and set 
the value to 255.

(If you accidentally open a plain text file in "document" mode 
and find that it's got WordStar codes in it after you save it, 
reopen the file in "nondocument" mode and issue ^QU to strip out 
those code and then save the file again.)   7   3                    
   7   3                    



 	

!
 SWAPPING CAPSLOCK AND CTRL

The classic WordStar interface was designed so that users never 
have to take their hands off the home typing row; this makes 
WordStar much more efficient for use by touch typists than either 
Microsoft Word or WordPerfect.  (WordStar supports a mouse, 
function keys, and cursor keys, but they are not required for any 
operation.)

As noted above, the classic WordStar interface is based on 
holding down the Ctrl key while issuing commands.  The original 
IBM PC keyboard had the Ctrl key just to the left of the letter 
A.  Later keyboards moved Ctrl to a pinkie-stretching position 
below the left Shift key and put CapsLock next to A.

It's a lot easier to use WordStar if you swap the functions of 
Ctrl and CapsLock -- and the included utility program SWAP.COM 
will do just that.  You can run it at the command prompt, but if 
you want it to run automatically each time you use WordStar, 
uncomment the line calling SWAP near the end of the file 
C:\WS\DOSBox-X\dosbox-x.conf (or, if you're using vDosPlus, in 
the file C:\WS\vDosPlus\autoexec.txt).

SWAP.COM only affects your WordStar session; it doesn't change 
the keyboard mapping for Windows.  (SWITCH.COM is identical to 
SWAP.COM; that was the original name WordStar gave to this 
utility, but if you're using the 4DOS command processor -- 
optional under DOSBox-X; the default under vDosPlus -- SWAP is an 
internal command and so a program with that name can't be called 
from the command line.)

I've also provided an alternative program that does the same 
thing called IBMFIX.COM.




 	!
 SPELLCHECKING A FILE

Under both DOSBox-X and vDosPlus, there's a small problem with 
the cursor when spellchecking a file: if you invoke the 
spellchecker in "Insert" (as opposed to "Ins-off") mode, the 
cursor will only appear as a line at the top of the first 
character in a word that's not in the dictionary.  (When running 
natively under MS-DOS, WordStar did not have this problem.)

You can workaround this by using the ^V toggle, if necessary, to 
switch to "Ins-off" mode before invoking the spellchecker with 
the usual ^QL command.

Alternatively, you can call the spellchecker via the included 
WordStar macro SPL-ALL, which, by default, is assigned to the 
hotkey <Shift+F3>.  I have modified this macro to set "Ins-off" 
mode before it starts a global spellcheck.   7   3                    
   7   3                    
I've also provided a new macro, SPL-REST, that checks spelling 
starting at the current cursor position.  I've assigned this 
macro to the hotkey <F12>, but you can use the ^ME command to 
assign it (or any macro) to any hotkey your wish.

If you find the "Words Checked" dialog that displays a wordcount 
at the end of each spellcheck annoying, you can turn it off at 
WSCHANGE menu D (WordStar), C (Other features), A (Spelling 
check), L (Turn "Words checked" message on or off).  You can 
always get a count of the words in your file with the ^K? 
command.




 	pp!
 COPYING TO AND FROM THE WINDOWS CLIPBOARD

WordStar's ^K[ command reads in the text contents of the Windows 
clipboard at the cursor position.

WordStar's ^K] command copies the currently marked block to the 
Windows clipboard in plain-text ASCII format -- but there's a 
bug: the final character isn't copied, so make sure to mark one 
more character than you actually want copied to the clipboard.

If you find the copy-from or copy-to clipboard commands aren't 
working, issue ^KP<Esc>, which loads and abandons WordStar's 
printer routines and has the side-effect of clearing WordStar's 
memory.




 	!
 CUSTOMIZING WORDSTAR

To use WordStar for DOS with its default settings, just type WS 
(or WS and a filename) at the command prompt.  But you don't have 
to live with those defaults; one of WordStar's great strengths is 
that it's hugely customizable.  Run the program WSCHANGE to 
modify WordStar to your heart's content.

The WS.EXE provided here has been installed assuming its files 
will be in folder C:\WS (and a variety of subfolders below that), 
all of which will have been created for you if you unzipped 
WORDSTAR.ZIP properly.

If you want to change the drive letter or folders used by 
WordStar, run WSCHANGE and go to menu C (Computer), D (WordStar 
files), and either A (Define search paths) or B (Assign primary 
and secondary paths for all WordStar files).

And if you want to simply install an all-new copy of WordStar on 
whatever drive and in whichever folder(s) you wish, go to the 
C:\WS\INSTALL folder and run the program WSSETUP there, using 
this serial number: 33787979.

I've also provided a complete, pristine, unmodified-in-any-way    7   3                     WordStar installation in C:\WS\DEFAULT.  See the -README.TXT file 
in that folder for more information.

Screen colors can be modified at WSCHANGE menu A (Monitor), B 
Video Attributes Menu), A (Select colors individually).

If you go to WSCHANGE menu A (Console Menu), A (Monitor), C 
(Screen sizing) and set both "Height" and "Width" to zero, the 
main WordStar program will auto-adapt to your screen size.  This 
change has already been made to all the WordStar executables in 
C:\WS except for PRISTINE.EXE.

See "Installing and Customizing (WordStar 7).pdf" in 
C:\WS\MANUALS.

Full customization details are in the file PATCH.TXT.

For information on the customizations I've already made to the 
versions of WordStar in this archive, see VERSIONS.WS (or 
VERSIONS.TXT).

To customize WordStar's screen layout while you work, issue ^OB.  
To make permanent changes in the screen layout go to WSCHANGE 
menu D (WordStar), B (Editing settings), A (Edit screen, help 
level). You can change also WordStar's default help level here.  
Personally, I like to use help level 2, have the ruler line off 
by default, and (on Edit Screen Menu #2) both the "Style bar" and 
the "Status line" at the top of the screen.

You can also change WordStar's screen colors.  You do that at 
WSCHANGE menu A (Console), B (Video attributes), A (Select colors 
individually).  Note that both DOSBox-X and vDosPlus use oddball 
color combinations to achieve effects that WordStar natively 
doesn't support; these are the settings used for DOSBox-X:

Italics: set Character to "blink" [F10] and Background to "green"
Underline: set Character to "blink" and Background to "blue"
Strike-out: set Character to "blink" and Background to "red"

I personally like WordStar to ignore case by default when doing 
searches.  You can set WordStar's default "Find" and "Find and 
replace" options at WSCHANGE menu B (Editing Settings), G (Find 
and replace), A (Default rind a replace options).

NOTE: If you like the WordStar interface and approach to 
wordprocessing but would prefer a Windows program, give WordTsar 
by Gerald Brandt a try:


 	!
 http://wordtsar.ca




 	\
\
!
 MY PREFERRED WORDSTAR SETUP

SAWYER.EXE is a version of WordStar using science-fiction writer    7   3                     Robert J. Sawyer's customizations -- try it and see if you like 
them.  They can be changed by running "WSCHANGE SAWYER" at the 
command line.  Some of the modifications I made are documented in 
SAWYER.WS.  I've also turned off by default many of the elements 
that clutter the screen: the Style Bar, the Status Line, and the 
Ruler Line.  You can do this while editing with the ^OB command 
or turn them on or off by default at WSCHANGE menu <B>D</B>, B, 
A.  

If you are using SAWYER.EXE instead of the default WS.EXE, you 
will notice that WordStar dot commands display in a different 
color from regular text.  This is accomplished by having the 
default WordStar Paragraph Style in SAWYER.EXE set to "Sawyer 
Defaults," and having the strikeout character set to a blank 
space at WSCHANGE menu B (Printer), C (Printing Defaults), I 
(Strikeout Character).

A useful side-effect of this is that document and nondocument 
files now display text in different colors (cyan for documents 
and green for nondocuments).  "Documents" are WordStar files; 
"Nondocuments" are plain-text ASCII files.

Unlike the default WS.EXE, SAWYER.EXE has WordStar set to always 
display dot commands.  You can change this on the fly by issuing 
^OB within a document or change it permanently at WSCHANGE menu D 
(WordStar), B (Edit screen, help level), A (Menu #1),

Note that SAWYER.EXE has autosave turned on; it will save your 
document automatically after ten minutes of keyboard inactivity.  
You can turn this off, if you wish, by running "WSCHANGE SAWYER" 
at the command line, and then selecting menu D (WordStar), C 
(Miscellaneous), I (Auto-backup), and changing the value from 10 
(i.e., ten minutes) to 0 (zero, which disables automatic backup).

SAWYER.EXE also has WordStar's backup files (which are given the 
extension .BAK) hidden from its directory display, but they're 
still there.  You can customize which file types are hidden at 
WSCHANGE menu C (Computer), E (Directory Display), C (File types 
excluded from directory).

To easily compare PRISTINE.EXE -- an unmodified version of 
WordStar -- and SAWYER.EXE, run the file DEMO.BAT.



See VERSIONS.WS or VERSIONS.TXT for information about all the 
different versions of WordStar I've provided here.  Those files 
also describe the ways in which the WordStar executables in C:\WS 
have been modified from the standard defaults.



.cp4  5   3                     

 	

!
 PRINTING

For printing, I simply have WordStar "print to disk" with the 
output going to the folder C:\WS\TEMP.  I have the free utility 
PrintFilePrinter watch that folder.  It automatically produces an 
Acrobat PDF file whenever WordStar "prints" a file to that 
folder; that PDF file can then be printed on any modern printer.  
I've provided PrintFilePrinter as part of this archive; see 
C:\WS\PrinFilePrinter for more information (and make sure to set 
C:\WS\TEMP as the watched folder).

Among the WordStar printer definition files included in this 
version of WordStar (you can see them all by issuing ^P?) are 
these:

.rrP--------------L---------------------------------------------R

 	
 LASERJET.PDF:
 	h 
 a LaserJet print driver that sends its output 

 	
 to the temporary file C:\WS\TEMP\WORDSTAR.PCL.


 	
 LJ6DTP.PDF:
 	 
 same as above, but with enhanced typography for 

 	
 desktop publishing; see LJ6DTP.WS for details


 	
 HP4.PDF:
 	 
 same as LASERJET.PDF except that it sends its 

 	
 output to the physical LPT1: printer port on 

 	
 your computer


 	
 PS:
 	p 
 a generic PostScript driver
.rr--!---------------------------!------------------------------R

(Yes, it's awkward that WordStar's "printer definition files" and 
Adobe's "portable document format" files both use the same file 
extension, .PDF.  For what it's worth, WordStar starting using 
that extension in 1988; Adobe didn't start using it until 1992.)

Again, note that LASERJET.PDF, LJ6DTP.PDF, and PS.PDF have all 
been modified (with WordStar's PDFEDIT utility) to send their 
output to C:\WS\TEMP rather than to a printer port so that 
PrintFilePrinter can produce Adobe PDF files from their output, 
as discussed above.

Also note that ASCII.PDF and ASC256.PDF have had their default 
print-to-disk output file names changed from ASCII.WS and 
ASC256.WS to the more-appropriate ASCII.TXT and ASC256.TXT, 
allowing their output to be opened with Windows text editors.

If you print a file that contains a .PIX graphics tag (such as 
can be inserted with the ^P* command), I suggest exiting WordStar 
once printing is finished and then reloading WordStar again.  
WordStar can be unstable under both DOSBox-X and vDosPlus after 
printing graphics.  Better safe than sorry.  Note that the 
WordStar document version of this -README file contains a .PIX 
graphics tag at the very beginning for printing the WordStar 
wordmark/logo.




 	jj!
 THE EURO CURRENCY SYMBOL   7   3                    
   7   3                    
WordStar was last updated in 1992, seven years before the euro 
currency symbol was adopted in 1999.  I've modified three 
WordStar Printer Definition Files ("PDFs") to nonetheless support 
the euro symbol: LASERJET.PDF, LJ6DTP.PDF, and HP4.PDF.  This was 
done by patching these PDFs to replace character 9E from the PC8 
symbol set, which was the peseta symbol, with character BA from 
the Roman 9 symbol set, released in 1999, which is the euro 
character.  (The peseta was the Spanish unit of currency before 
Spain switched to using the euro.)

If you see the euro character right here , then you're all set 
to go (even if you don't see it, the above-named PDFs will still 
print it).  If you don't see it and you are running WordStar 
under DOSBox-X, edit the dosbox-X.conf configuration file and 
under the [render] section set "euro=158" and WordStar (and all 
other programs) will show the euro instead of the peseta symbol.

To insert the euro symbol in a WordStar document, access the ^P0 
(^P-zero) "Extended Character" menu and either type the code for 
it (158) or just click on the euro symbol with your mouse.

.cp3



 	!
 CONVERTING FROM WORDSTAR TO WORD

To convert files from WordStar format to something a modern word 
processor can read, use the provided Star Exchange program (a 
rebranded version of Software Bridge).  You can either run it 
from WordStar's opening menu (press A then S to activate it) or 
as a standalone program:


 	!
 C:\WS\CONVERT\CONVERT.EXE

Alternatively, you can use the program Word for Word, also 
abandonware.  It's in C:\WS\WFW.  If you'd like Windows wrapper 
for it, so that you can run it directly under Windows, run this 
file provided by Edward Mendelson:


 	hh!
 "C:\WS\LegacyFileConverter\LegacyFileConverter Installer.exe"

Documentation for LegacyFileConverter is here:


 	!	
 https://mendelson.org/legacyfileconverter.html

You may find that converting from WordStar to RTF (rich text 
format) works better for import into modern word processors than 
does the ancient version of the Microsoft Word DOC format these 
programs support.

You can also try the old ConvertPerfect utility from WordPerfect; 
it's in C:\WS\CVWP.

And another conversion utility, WS-CON, is in C:\WS\WS-CON.

Finally, my own very elaborate, very sophisticated, and very    7   3                     idiosyncratic system for converting WordStar documents to RTF can 
be found in C:\WS\RTF-RJS.  This system may or may not work for 
you and may or may not require customization.




 	!
 USING BATCH FILES

DOSBox-X doesn't like the way WordStar terminates after it has 
edited a file, so in batch files, follow each instance of calling 
WS.EXE with theses two lines:

on break goto AfterWS1
:AfterWS1

(Increment the number for successive invocations of WordStar 
later in the same batch file.)

This will bypass the "Cancel batch job?" error DOSBox-X throws.  
Neither vDosPlus nor vDos have this problem.  See the file 
DEMO.BAT for an example of this workaround.



.cp5

 	!
 THERE'S LOTS MORE HERE!

Have a look in each folder in this archive; in many of them, 
you'll find a -README.TXT or -README.WS file giving further 
information.

WordStar came with a number of "Companion Programs," all of which 
I've provided (including PC-Outline, which came with WordStar 
5.0, 5.5, and 6.0, but was dropped in 7.0; it's in C:\WS\PCO).  
See the Companion Programs manual in C:\WS\MANUALS.  I find 
ProFinder (in C:\WS\PF) particularly useful; just type PF at the 
command prompt to give it a try.

You'll find a bunch of useful utility programs in C:\WS\UTIL.

And there are lots of other goodies, too!




 	!
 FOR MORE INFORMATION

I've provided all the documentation that came with WordStar 7.0 
as full-text-searchable Adobe Acrobat PDF files.  They are in the 
folder C:\WS\MANUALS.

See also the various *.WS and *.TXT files in C:\WS and its 
subfolders.

See my page about WordStar here:


 	@@!
 https://sfwriter.com/wordstar.htm   7   3                    
   7   3                    
And see my page about using WordStar under vDosPlus, which has a 
lot of technical information about WordStar, here:


 	!
 https://sfwriter.com/ws-vdos.htm

Finally, if you need any help, feel free to email me -- Robert J. 
Sawyer -- at:


 	,,!
 sawyer@sfwriter.com




 	::!
 WORDSTAR CREDITS

WordStar was originally released in 1978.  The program was 
entirely coded and the interface designed by Rob Barnaby.  
Seymour Rubinstein had hired him to do that, and Seymour marketed 
the program.

Rob Barnaby's original codebase was built upon until WordStar 
3.3.  Starting with WordStar 4.0, an all-new codebase was written 
by Peter Mierau.  John Morris was the lead programmer on WordStar 
6.0.  Joe Masters and John Nolan were the lead programmers on 
WordStar 7.0.

Hidden in WS.EXE, only visible with a hex editor, are the credits 
for WordStar for DOS 7.0.  Here they are; sadly, most of the full 
names or last names are lost to history -- but they all have my 
thanks for creating the best wordprocessing program the world has 
ever seen:

 	 
 	
 Programming: corbett, jims, joem, johna, johnn, 

 	
 laurieo, markh, myles, timl, tomp, victoriaa.


 	
 Printers: charles, markhen.  


 	
 Testing: adriano, chrism, donc, hunterm, jimsu, johnt, 

 	
 karenp, kimp, lisav, mardi, maryv, normm, pattia, rick, 

 	
 sandram.


 	
 Writers: harrieto, rachels, trudyf, carolinem, debbieg, 

 	
 kathya.


 	
 Editors: beverlyj, sande, frankc.  


 	
 Production: shauneyl, mikef, janeg.  


 	
 Design: melanie, marylld, susans.


 	
 Support: james, kevinb, richz.  


 	
 Thanks to: bobbie, bradyb, charlotte, helen, royk, 

 	
 WABbits, beta testers.


 	
 Managers: alexh, lisal, dani, davidp, georgia, tanas 	
    7   3                    
   7   3                    
"WABits" were the members of the WordStar Advisory Board, a 
power-users panel convened by me (Robert J. Sawyer) and reporting 
directly to the CEO of WordStar International (formerly 
MicroPro), the company that published WordStar.



Who the heck is Robert J. Sawyer?  He's a former sysop of the 
WordStar Forum on the CompuServe Information Service and, as 
noted above, he was the convenor of the WordStar Advisory Board, 
a panel of power users that reported directly to the CEO of 
WordStar International.

A member of the Order of Canada, Rob is a Hugo and Nebula 
Award-winning science-fiction writer.  He has written every one 
of his twenty-five novels with WordStar, which he has been using 
since 1983, starting with WordStar version 2.26 on an Osborne 1 
CP/M computer.  

You can read one of his short stories in the file OLDTIMES.WS.  
His massive website -- all hand-coded in HTML in WordStar's 
nondocument mode -- is at:


 	!
 https://sfwriter.com
U 
 f 
   
    WordStar Defaults          J|    WordStar Defaults          J|    ????????????????????????   J|    Default Ruler Line        v\  ????????????????????????   |    Bulleted List             G   ????????????????????????   D    ????????????????????????       ????????????????????????   *    Quotation                 f        -   
 (#&                                                       y beginning for printing 
the WordStar wordmark/logo.

N      h     h8p	@x                                                        F    0*   
 (#&                                                            G   ????????????????????????   D    ???????