}  p1720 JET   9                                                                                                           } Whatever Happened to Wordstar?

by John C. Dvorak

One of the most interesting stories in the history of computing 
surrounds the dominant word processor of the late 1970?s and 
early 1980?s -- Wordstar.

The brains behind it included industry pioneer Seymour 
Rubenstein, who much later developed a spreadsheet product called 
Surpass which became Quattro Pro. Rubenstein had worked for IMSAI 
under his then mentor Bill Millard where he ran into superstar 
assembly language coder, Rob Barnaby. After his stint with IMSAI 
and after working on a banking system for Credit Suisse 
Rubenstein decided to start a company. He began studying the 
Datapro reports on dedicated word processors and decided he 
wanted to do a software company. He called it Micropro 
International. The first two products were a word processor and a 
sorting program which he got Barnaby to code. In just a few 
months, while coding two products simultaneously, Barnaby 
produced Supersort and Wordmaster which were released in Sept of 
1978 at a computer show in New York. Rubenstein sold $12,000 
worth of the programs at the show and was in business to stay.

Dealer feedback for Wordmaster indicated that there was a need 
for built-in printing. Word processors at the time typically had 
separate programs you ran to print the documents after you edited 
them. The Electric Pencil, arguably the first modern word 
processor incorporated printing in the program and dealers wanted 
the Micropro product to do the same thing.

In Oct. of 1978, a month after introduction, Barnaby began coding 
Wordstar with new features. According to Rubenstein, who 
carefully tracked Barnaby's work, it took four months to code 
Wordstar. This was done in assembler from scratch. Only 
10-percent of Wordmaster code was used. That was the text 
buffering algorithms. In four months Barnaby wrote 137,000 lines 
of bullet-proof assembly language code. Rubenstein later checked 
with some friends from IBM who calculated Barnaby's output as 
42-man years.

A few years later when Epson wanted a special ported version of 
Wordstar for its first portable computer the Epson reckoned that 
it would take six months to port the code. Rubenstein told them 
that it only took four months to code the product from scratch 
and rehired Barnaby for the port at $100/hr. Rob finished the job 
in three weeks. According to Rubenstein Barnaby was the "mad 
genius of assembly language coding."

During this era Barnaby, who was a character in many ways, used 
to love to drive around a large and old Rolls-Royce limo, dressed 
as a chauffeur. He was probably the most famous programmer of the 
era.

Sales were flying for Wordstar and Micropro. In fiscal 1979 the    7   3                     company did $500,000. Sales jumped to $1.8 in 1980, $5.2 million 
in 1981. Then the company ported the product from CP/M to CP/M-86 
and PC-DOS and released it for the IBM PC in April of 1982 and 
sales skyrocketed to $23 million. It reached $45 million in 1983. 
In 1984, just as the company was going public the sales were up 
to $70 million. At the time it was the biggest software company 
in the country.

Two months before the public offering in 1984 disaster struck 
Rubenstein. Not someone who anyone would describe as low-key, 
Rubenstein suffered a heart attack. Back in 1980 or so he made 
the mistake of bringing in a venture capitalist who was 
introduced to Rubenstein by Rubenstein's brother's 
brother-in-law. That kind of combination had the words "bad idea" 
written all over it. "It was the biggest mistake I ever made in 
my life," says Rubenstein. The guy was Fred Adler who sent Fred 
Haney into Seymour's hospital room with a document that Seymour 
had to sign converting all his stock into non-voting stock "or 
the public offering would be killed." Rubenstein who still 
shudders when he thinks of his brush with death says he was so 
frightened by the heart attack that he wasn't in the mood to 
argue with anyone about anything. From that moment the company 
lost its edge. Haney, an ex-Sperry-Univac guy took over as CEO at 
Adlers request.

It was during this later era that a slew of newcomers to the word 
processing scene cropped up. Volkswriter, Word Perfect, XYwrite, 
Word, Newword and a host of competitors began to battle for 
hegemony. Eventually Word Perfect rose to the top based on its 
superior support program. A lot of professional writers flocked 
to XYwrite. I recall when I first went to work at PC Magazine in 
1986 and found most people were XYwrite users at the time with 
the exception of a few Wordstar die-hards such as Paul Somerson. 
It was only much later as XYwrite fell by the wayside that 
WordPerfect dominated the scene until it was sold to Novell where 
it languished and was eventually sold to Corel.

Wordstar ran into all sorts of problems during this era. 
Rubestein's original vision for the company, which was renamed to 
Wordstar International. was to bring out a complete suite of 
integrated systems. In the early 1980?s the company released 
Calcstar and Datastar and integrated them with Wordstar into a 
system called Starburst. I had played with this package and it 
was phenomenal for its era. Adler and company killed this idea. 
In fact it was the original "office" suite.

While Wordstar was still the best word processor on the market 
until the mid-1980?s it lacked a couple of features that annoyed 
users. As DOS was improved and UNIX-like paths were added, 
Wordstar could not initially accomodate paths. Worse it had no 
UNDO key. The code base by now was turning into spaghetti code 
and Barnaby wasn't around to fix things. Worse, in 1985, the 
company produced Wordstar2000, a copy protected program that was 
nothing like the older lovable Wordstar and which contained 
annoying copy-protection features that scared most users away.    7   3                     While many pundits including Esther Dyson predicted great things 
for Wordstar2000, users rejected it. The product was big and slow 
and expensive. And despite complaints by the company and others, 
people wanted software they could copy and use on more than one 
machine. During this era piracy sold software and created market 
share. People would use a bootleg copy of Wordstar and eventually 
buy a copy. Wordstar may have been the most pirated software in 
the world, which in many ways accounted for its success. 
(Software companies don't like to admit to this as a 
possibility.) Books for Wordstar sold like hot cakes and the 
authors knew they were selling documentation for pirated copies 
of Wordstar. The company itself should have just sold the 
documentation alone to increase sales. This was the 
wink-wink-nudge-nudge aspect of the industry at the time and 
everyone knew it. So when Wordstar2000 arrived with a copy 
protection scheme everyone should have predicted its immediate 
demise. By the time the company removed copy protection it was 
too late to save it. One curiosity was the 1985 release of 
Wordstar2000 for UNIX! Wordstar would later evolve into Wordstar 
professional and Wordstar for Windows (which developed a cult 
following), but it was an uphill battle despite superior 
usability. The edge was gone.

Wordstar2000, to me, symbolized the downturn and general muddy 
thinking that took over the company. The original Wordstar code 
base was replaced by a Wordstar clone called NewWord which was 
just like Wordstar but incorporated Undo and other features. 
While not coded in speed bullet-proof Barnaby assembler it worked 
well and kept the product alive long enough for Wordstar 
International to sell everything to Softkey where the decline 
continued until it was bought out by Corel, "I guess Corel wants 
to own all the defunct word processors in the world," lamented 
Rubenstein.

Wordstar was the product that invented the "what you see is what 
you get" notion later to be dubbed WYSIWYG. It invented numerous 
features including overlays, later to develop into DLL's. It was 
the first product with dynamic pagination and even help levels 
among other new features. All modern word processors owe their 
existence to Wordstar -- perhaps one of the greatest single 
software efforts in the history of computing.
.pa  %
*   3                     
Whatever Happened to NewWord?

by John C. Dvorak

One of the great Word Processors of the early desktop computing 
era was NewWord, a product that evolved from mismanagement at the 
company that gave us Wordstar, MicroPro International/Wordstar 
Corporation.

Wordstar was making a transition to the DOS world from CP/M and 
released a PC version of its dominant Word Processor in 1982. It 
was a recompiled version of the CP/M source code with patches. 
But somewhere along the way the original documented source code 
was lost! One of the top programmers at the company Peter Mierau 
was in the process of reconstructing the code base during this 
era. He was apparently the only guy who could make any sense out 
of what was described to outsiders as "spaghetti code."

In October of 1982, shortly after he finished this tedious job 
the company laid him off along with pals Stan Reynolds and 
Richard Post as part of a cost-cutting move. The irked threesome 
decided to form their own company to clone Wordstar from scratch. 
This happened fast as Reynolds still had a company car for a 
month and the trio drove the car down to COMDEX Vegas with a 
business plan looking for investors.

It was there they found George Morrow who was heading a 
successful manufacturing company making inexpensive Z-80-based 
personal computers and bundling a lot of software with each 
machine. Seeing the potential to invest a fixed amount of 
capital, about $100,000, to get this new company off the ground 
Morrow could grab a free license for the new product and not have 
to pay any more fees to bundle Wordstar. The company, called 
NewStar, was off and running with Reynolds as President.

They shipped NewWord version 1 in September of 1983. It was a 
subset of Wordstar and MailMerge with 80-percent of the features. 
By August of 1984 they shipped version two which excited the 
installed base of Wordstar 3.3 users. Many devoted Wordstar users 
switched to it immediately. Word Perfect came along during this 
era and within no time took market leadership away from Wordstar 
with more modern features. WordPerfect also claimed to be "easier 
to use" which still galls Stan Reynolds to this day. In fact 
WordPerfect was as unintuitive as any word processor ever 
released, but it used the function keys and the marketeers argued 
that it was easier because of that fact.

Version 2 of NewWord also added other characteristics that 
Wordstar user wanted badly including the addition of an Unerase 
feature which was missing from Wordstar. These new features 
included: laser printer support, built-in spell checking, 
unlimited block sizes for block delete and block move, ability to 
make columns, file locking and a menu-driven install system. The 
entire program was coded in speedy assembly language by Mierau 
and his team.   7   3                    
   7   3                    
The company was in business now and Morrow sold back most of the 
company to the founders and kept a minority share and the 
perpetual license. Some beef or other arose with partner Richard 
Post around the time of the release of NewWord 3 which added the 
additional features including keyboard macros, math functions, as 
well as pathnames. Post was bought out. While Wordstar had not 
been seriously updated new versions of DOS with pathnames had 
been released. Wordstar could not take advantage of paths and you 
had to have a copy of Wordstar in the directory where the 
documents were retrieved and saved. It was this missing feature 
in Wordstar in 1986 that was killing the product along with the 
fact that a management coup had taken place after the founder 
Seymour Rubenstein had an unfortunate, but not fatal, 
heart-attack (see article on Wordstar).

During the NewWord era Wordstar had tried a couple of things to 
get back on top of the word processing game. The company released 
Wordstar2000 which was copy protected to excess and represented 
early bloatware. The Wordstar users didn't like it. The company 
also took the source code earlier rebuilt by Mierau and attempted 
to upgrade Wordstar 3.3 and produced an unsalable product that 
was rejected by the company's outside beta testers. This led the 
board to fire the acting CEO. The company was in a quandary and 
new CEO Leon Williams was brought in to save the operation.

It was then that the VP of Sales and Marketing at NewStar, Walt 
Feigenson, put together a meeting with Leon Williams and Wordstar 
in late 1986. Reynolds and team were either going to sell to 
Wordstar or buy Wordstar somehow. They were offered $3 million 
for NewWord and decided to take the money and run. The product 
was modified with new menus and the addition of background 
printing to become Wordstar 4 and shipped in February of 1987 and 
at the time was the biggest and most successful upgrade in 
software history.

The NewStar folks were given a one year employment contract which 
was never renewed and the guys went their separate ways.

In the short term the acquisition saved Wordstar but it was only 
a short term fix. You have to wonder what would have been if the 
NewStar guys were inclined to buy Wordstar or just compete in the 
business. The decision to bail out for what seems like a pittance 
in todays Internet mad world may have been wise in 1986 There 
were dozens of Word Processors competing and Microsoft hadn't 
begun to push Word seriously. Furthermore this was an era when 
the Venture Capital community thought investing in software 
companies was a bad idea. Times change.

The most ironic aspect to this story is that in todays world the 
NewWord guys would have been sued from the beginning for look and 
feel or something similar. The product would have never been 
completed and improved and Wordstar would have never had the 
opportunity to buy it to save their own hides. Yes, times change.
.pa  6   3                     
