;
; Convert WS5 files to ASCII
;
; Written by Peter Mierau
;
ws5asc	segment
assume	cs:ws5asc,ds:ws5asc,es:ws5asc,ss:ws5asc

;
; Beginning of code
;
	org	100h
wbegin:	jmp	w1

;
; Equates
;
cr	equ	0dh
lf	equ	0ah

;
; Messages
;
whelp	db	'Convert a WordStar 5.0 file to ASCII.',cr
	db	cr
	db	'WS5ASC WS5FILE ASCFILE {/H}{/N}{/T}',cr
	db	cr
	db	'/H converts characters beyond 126 to plain ASCII',cr
	db	'/N does not remove dot commands',cr
	db	'/T does not convert tab characters (ASCII 9) to blanks',cr
	db	0
;
wmem	db	'Insufficient memory',0
wfind	db	'Can''t find ',0
wcreate	db	'Can''t create ',0
wread	db	'File read error',0
wwrite	db	'Disk full or write error',0
wsym	db	'Bad symmetrical sequence',0

;
; Variables
;
win	dw	?		; Input buffer
winend	dw	?		; End of input buffer
winhan	dw	?		; Handle	
;
wout	dw	?		; Output buffer
woutend	dw	?		; End of output buffer
wouthan	dw	?		; Handle	
woutcol	db	0		; Current output column
;
whigh	db	0		; /H option flag
wnon	db	0		; /N option flag
wtab	db	0		; /T option flag
wdot	db	1		; Check for dot command flag
wignore	db	0		; Ignoring dot command line flag
wprev	db	0		; Previous character output

;
; Begin
;
w1:	cld			; Set standard direction flag
;
	mov	sp,offset wstack; Top of stack
;
	mov	dx,ds:[2]	; Get topmost paragraph of RAM
;
	mov	ax,ds		; Is full 64k available?
	add	ah,10h
	cmp	ax,dx
	jbe	w3
;
	mov	si,offset wmem	; Not enough RAM
;
w2:	call	msg		; Error message, abort
	mov	ax,4C01h
	int	21h
;
w3:	mov	ax,offset walloc; Allocate input buffer
	mov	win,ax
	add	ax,wallbf
	mov	winend,ax
;
	mov	wout,ax		; Allocate output buffer
	add	ax,wallbf
	mov	woutend,ax
;
w4:	call	woption		; Proccess /options
;
	mov	si,81h		; Extract input file
	mov	di,win
	call	wfile
	jnc	w6
;
w5:	mov	si,offset whelp	; Help the user
	jmp	w2
;
w6:	mov	di,wout		; Extract output file
	call	wfile
	jc	w5
;
	mov	dx,win		; Open input file
	mov	ax,3D00h
	int	21h
	jnc	w7
;
	mov	si,offset wfind	; Can't find it
	call	msg
	mov	si,dx
	jmp	w2
;
w7:	mov	winhan,ax	; Input file handle
;
	mov	dx,wout		; Create output file
	xor	cx,cx
	mov	ah,3Ch
	int	21h
	jnc	w8
;
	mov	si,offset wcreate; Can't
	call	msg
	mov	si,dx
	jmp	w2
;
w8:	mov	wouthan,ax	; Output file handle
;
	mov	di,wout		; Initial input/output buffer pointers
	mov	si,winend
;
w9:	call	winbyte		; Get next byte from WS5 file
	jc	w14
;
	and	al,7Fh		; Strip MSB
;
	cmp	wnon,1		; Nondocument?
	jz	w11
;
	cmp	wdot,0		; Don't check for dot commands?
	jz	w11
;
	cmp	al,'.'		; Not a dot?
	jnz	w10a
;
	mov	wignore,1	; Ignore the rest of the line
;
w10a:	mov	wdot,0		; No longer at start of line
;
w11:	cmp	al,' '		; Special WS5 character?
	jb	w15
	cmp	al,7Fh
	jae	w15
;
w12:	call	woutbyte	; Write a byte to output file
	jmp	w9
;
w13:	mov	si,offset wwrite; Write error
	jmp	w2
;
w14:	call	wflush		; Flush output buffer
;
	mov	bx,winhan	; Close input and output files
	mov	ah,3Eh
	int	21h
	mov	bx,wouthan
	mov	ah,3Eh
	int	21h
	jc	w13
;
	mov	ax,4C00h	; Done, return to DOS
	int	21h
;
w15:	cmp	al,'I'-'@'	; ^I tab?
	jz	w16b
;
	cmp	al,'M'-'@'	; ^M carriage return?
	jz	w12
;
	cmp	al,'J'-'@'	; ^J line feed?
	jz	w16a
;
	cmp	al,'L'-'@'	; ^L form feed?
	jz	w16d
;
	cmp	al,'F'-'@'	; ^F phantom space?
	jz	w16
;
	cmp	al,'O'-'@'	; Not ^O binding space?
	jnz	w17
;
w16:	mov	al,' '		; Convert to a space
	jmp	w12
;
w16a:	call	woutbyte	; Check for dot command at start of next line
	mov	wdot,1
	mov	wignore,0
	jmp	w9
;
w16b:	cmp	wtab,1		; Don't convert tabs to blanks?
	jz	w12
;
w16c:	mov	al,' '		; Expand tab
	call	woutbyte
	test	woutcol,7
	jnz	w16c
	jmp	w9
;
w16d:	cmp	wprev,cr	; Not a column break?
	jnz	w16a
;
	mov	al,lf		; Convert to LF
	jmp	w16a
;
w17:	cmp	al,'G'-'@'	; Not ^G phantom rubout?
	jnz	w18
;
	mov	al,'~'		; Convert to squiggle
	jmp	w12
;
w18:	cmp	al,'['-'@'	; Not ^[ escape?
	jnz	w20
;
	call	winbyte		; Get possible extended char
	push	ax
;
	call	winbyte		; See if ^\ follows extended char byte
	cmp	al,'\'-'@'
	jnz	w19
;
	pop	ax
;
	cmp	whigh,0		; Not converting extended characters?
	jz	w18b
;
	mov	bx,offset wxlax	; Extended char from 00 to 2F?
	cmp	al,80h
	jb	w18a
;
	mov	bx,offset wxlat	; Translate to plain ASCII
	sub	al,80h
w18a:	xlat
w18b:	jmp	w12
;
w19:	mov	dl,al		; Must be just an escape character
;
	mov	al,'['-'@'	; Send the three bytes just read
	call	woutbyte
;
	pop	ax
	call	woutbyte
;
	mov	al,dl
	jmp	w18b
;
w20:	cmp	al,']'-'@'	; Symmetrical sequence?
	jz	w22
;
	cmp	al,'_'-'@'	; Soft hyphen at end of line?
	jz	w21
;
	jmp	w9		; Ignore everything else
;
w21:	mov	al,'-'		; Dash
	jmp	w18b
;
w22:	call	winbyte		; Get size of sym seq
	mov	cl,al
	call	winbyte
	mov	ch,al
;
	call	winbyte		; Get sym seq type
;
	cmp	al,9		; Tab?
	jz	w26
;
	or	al,al		; Not file header?
	jnz	w23
;
	mov	wdot,1		; Check for dot command again
;
w23:	dec	cx		; End of sym seq?
	jcxz	w24
;
	call	winbyte		; Ignore rest of sym seq
	jnc	w23
	jmp	short w25
;
w24:	cmp	al,']'-'@'	; Didn't end with proper terminator?
	jnz	w25
;
	jmp	w9
;
w25:	mov	si,offset wsym	; Bad sym seq
	jmp	w2
;
w26:	mov	dl,4		; Ignore HMI information within tab
w27:	call	winbyte
	dec	dl
	jnz	w27
;
	call	winbyte		; Get tab type
	mov	dl,al
;
	call	winbyte		; Get tab size
	jc	w25
	mov	dh,al
;
	sub	cx,6		; Read six bytes
	jbe	w25
;
	inc	dh		; Tab size 255 or zero?
	jz	w23
	dec	dh
	jz	w23
;
	cmp	dl,'.'		; Dot leader?
	jz	w28
;
	mov	dl,' '		; Use blanks
;
w28:	mov	al,dl		; Expand tab
	call	woutbyte
	dec	dh
	jnz	w28
;
	jmp	w23		; Ignore rest of sym seq

;
; Read byte from input
;
;	On entry: SI -> intput buffer
;
;	On exit:  AL = byte
;		  CY if end of file
;
winbyte:
	cmp	si,winend	; End of buffer?
	jz	winb1
;
	lodsb
	clc
	ret
;
winb1:	push	bx
	push	cx
	push	dx
;
	mov	dx,win		; Read next chunk of file
	mov	si,dx
	mov	cx,wallbf
	mov	bx,winhan
	mov	ah,3Fh
	int	21h
;
	pop	dx
	pop	cx
	pop	bx
	jnc	winb2
;
	mov	si,offset wread	; Read error
	jmp	w2
;
winb2:	add	si,ax		; New end of input buffer
	mov	winend,si
	mov	si,win
;
	or	ax,ax		; Not yet end of file?
	jnz	winbyte
;
	stc
	ret
;
; Write byte to output
;
;	On entry: AL = byte
;		  DI -> output buffer
;
woutbyte:
	mov	wprev,al	; Store as previous character
;
	cmp	wignore,1	; Ignoring a dot command?  (NC)
	jz	woutb2
;
	cmp	di,woutend	; End of buffer?
	jz	woutb4
;
	cmp	al,' '		; Control char?
	jb	woutb3
;
	inc	woutcol		; Increment output column
;
woutb1:	stosb			; Store char in buffer
	clc
woutb2:	ret
;
woutb3:	cmp	al,cr		; Not end of line?
	jnz	woutb1
;
	mov	woutcol,0	; Position output column at left edge
	jmp	woutb1
;
woutb4:	push	ax
	push	bx
	push	cx
	push	dx
;
	mov	dx,wout		; Write bufferful to disk
	mov	di,dx
	mov	cx,wallbf
	mov	bx,wouthan
	mov	ah,40h
	int	21h
;
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	jnc	woutbyte
;
woutb5:	mov	si,offset wwrite; Write error
	jmp	w2
;
; Flush output buffer
;
;	On entry: DI -> output buffer
;
wflush:
	push	bx
	push	cx
	push	dx
;
	mov	dx,wout		; Write bufferful to disk
	mov	cx,di
	mov	di,dx
	sub	cx,dx
	jz	wflus1
	mov	bx,wouthan
	mov	ah,40h
	int	21h
;
wflus1:	pop	dx
	pop	cx
	pop	bx
	jc	woutb5
	ret
;
; Extract filename from command line
;
;	On entry: SI -> filename
;		  DI -> storage spot
;
;	On exit:  CY if no filename
;		  SI -> following filename
;
wfile:
	push	di
;
wfil1:	lodsb			; End of command line?
	cmp	al,cr
	stc
	jz	wfil4
;
	cmp	al,' '		; Ignore leading blanks
	jz	wfil1
;
	dec	si		; Copy filename to buffer
wfil2:	lodsb
	cmp	al,' '		; End of filename?
	jz	wfil3
	cmp	al,cr
	jz	wfil3
;
	stosb
	jmp	wfil2
;
wfil3:	xor	al,al		; Null terminate (NC)
	stosb
;
wfil4:	pop	di
	ret
;
; Extract command line options
;
woption:
	push	si
;
	mov	si,81h		; Scan for slash
wopti1:	lodsb
	cmp	al,'/'
	jz	wopti2
;
	cmp	al,cr
	jnz	wopti1
;
	jmp	short wopti9
;
wopti2:	lodsb			; Get option letter
	call	upper
;
	cmp	al,'N'		; Nondocument?
	jz	wopti4
;
	cmp	al,'T'		; Tab?
	jz	wopti5
;
	cmp	al,'H'		; Not a valid option?
	jnz	wopti1
;
	mov	whigh,1		; Convert symbols to close ASCII equivalent
;
wopti3:	mov	word ptr [si-2],'  '; Blank out option
	jmp	wopti1
;
wopti4:	mov	wnon,1		; Don't strip out dot commands
	jmp	wopti3
;
wopti5:	mov	wtab,1		; Don't expand tabs
	jmp	wopti3
;
wopti9:	pop	si
	ret
;
; Lower to upper case
;
;	On entry: AL = character
;
;	On exit:  AL = upper case character
;
upper:
	cmp	al,'a'
	jb	uppe1
	cmp	al,'z'
	ja	uppe1
	sub	al,'a'-'A'
uppe1:	ret
;
; Display message
;
;	On entry: SI -> null terminated message
;
msg:
	lodsb			; Done?
	or	al,al
	jz	ms2
;
	cmp	al,cr		; End of line?
	jz	ms1
;
	call	co		; Display char
	jmp	msg
;
ms1:	call	crlf		; Next line
	jmp	msg
;
ms2:	ret
;
; Carriage return, line feed
;
crlf:
	mov	al,cr
	call	co
	mov	al,lf
;
; Console output
;
;	On entry: AL -> character
;
co:
	push	dx
;
	mov	dl,al		; Use DOS to output character
	mov	ah,6
	int	21h
;
	pop	dx
	ret
;
; Extended character translation table
;
wxlat	db	43h		; Extended codes from 80 to FF
	db	75h
	db	65h
	db	61h
	db	61h
	db	61h
	db	61h
	db	63h
	db	65h
	db	65h
	db	65h
	db	69h
	db	69h
	db	69h
	db	41h
	db	41h
	db	45h
	db	61h
	db	41h
	db	6Fh
	db	6Fh
	db	6Fh
	db	75h
	db	75h
	db	79h
	db	4Fh
	db	55h
	db	63h
	db	4Ch
	db	59h
	db	50h
	db	53h
	db	61h
	db	69h
	db	6Fh
	db	75h
	db	6Eh
	db	4Eh
	db	61h
	db	6Fh
	db	3Fh
	db	2Dh
	db	2Dh
	db	32h
	db	34h
	db	21h
	db	3Ch
	db	3Eh
	db	3Dh
	db	3Dh
	db	3Dh
	db	7Ch
	db	7Ch
	db	7Ch
	db	7Ch
	db	2Bh
	db	2Bh
	db	7Ch
	db	7Ch
	db	2Bh
	db	2Bh
	db	2Bh
	db	2Bh
	db	2Bh
	db	2Bh
	db	2Dh
	db	2Dh
	db	7Ch
	db	2Dh
	db	2Bh
	db	7Ch
	db	7Ch
	db	2Bh
	db	2Bh
	db	2Dh
	db	2Dh
	db	7Ch
	db	3Dh
	db	2Bh
	db	3Dh
	db	2Dh
	db	2Dh
	db	3Dh
	db	2Bh
	db	2Bh
	db	2Bh
	db	2Bh
	db	2Bh
	db	2Bh
	db	2Bh
	db	2Bh
	db	3Dh
	db	3Dh
	db	7Ch
	db	7Ch
	db	3Dh
	db	61h
	db	42h
	db	67h
	db	6Eh
	db	45h
	db	72h
	db	75h
	db	74h
	db	6Fh
	db	4Fh
	db	6Eh
	db	73h
	db	6Fh
	db	4Fh
	db	45h
	db	6Eh
	db	3Dh
	db	2Bh
	db	3Eh
	db	3Ch
	db	66h
	db	6Ah
	db	2Fh
	db	7Eh
	db	2Ah
	db	43h
	db	2Eh
	db	2Fh
	db	6Eh
	db	32h
	db	3Dh
	db	20h
;
wxlax	db	' OOV+&%.O0'	; Extended codes from 00 to 1F
	db	'0bpPMX><I!'
	db	'PS_I^v><L='
	db	'^V'

;
; Stack must be last in file
;
	db	256 dup(?)
wstack	label	byte

;
; Allocated buffers go here
;
	even
walloc	label	byte
walloz	equ	$-offset wbegin+100h; Size of program
wallbf	equ	(0FFFFh-walloz)/2   ; Half the remaining space

ws5asc	ends
	end	wbegin
